<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CategoryLanguage extends Model 
{

    protected $table = 'lim_category_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_category_id', 'name', 'summary', 'content');
    protected $visible = array('lim_language_id', 'lim_category_id', 'name', 'summary', 'content');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'lim_category_id');
    }

}